$(function(){
	
	init();
});

function init(){
	$("#mark").empty();
	var w = 400;
	var h = 320;
	//获取浏览器版本
	var browserVersion = getBroswer();

	if(browserVersion.broswer == "Firefox" || browserVersion.broswer == "Chrome"  || (browserVersion.broswer == "IE" && browserVersion.version >= 9)) {
		var box = '<div class="box">' +
			'<video id="video" width="' + w + '" height="' + h + '" controls></video>' +
			'<p>确认图像清晰，人脸完整显示在取景框内</p>' +
			'<button id="confirm">确定</button>' +
			'<canvas id="canvas" width="' + w + '" height="' + h + '"></canvas>' +
			'</div>';
		$("#mark").append(box);
		var leaveTime = $("#time").val();
		videos(0, leaveTime, 3)
		//	videos(0, data.time, data.number);
	} else {
		$("#mark").hide();
	}
}
//startTime开始时间,endTime结束时间, Number照片数量
function videos(startTime, endTime, Number) {

	var mediaStream; //关闭摄像头参数
	var open = false; //摄像头请求是否成功

	//访问用户媒体设备的兼容方法
	function getUserMedia(constraints, success, error) {
		if(navigator.webkitGetUserMedia) {
			//webkit核心浏览器
			navigator.webkitGetUserMedia(constraints, success, error)
		} else if(navigator.mozGetUserMedia) {
			//firfox浏览器
			navigator.mozGetUserMedia(constraints, success, error);
		} else if(navigator.getUserMedia) {
			//旧版API
			navigator.getUserMedia(constraints, success, error);
		}
	}

	//成功回调
	function success(stream) {
		//兼容webkit核心浏览器
		var CompatibleURL = window.URL || window.webkitURL;
		//将视频流设置为video元素的源
		mediaStream = typeof stream.stop === "function" ? stream : stream.getTracks()[0];
		video.src = CompatibleURL.createObjectURL(stream);
		video.play();
		open = true;
	}

	//失败回调
	function error(error) {
		console.log('访问用户媒体设备失败' + error.name + ":" + error.message);
		if(error.name == "NotFoundError" || "DeviceNotFoundError") {
			$("#mark").hide();
		}
	}

	//判断浏览器内核
	if(navigator.getUserMedia || navigator.webkitGetUserMedia || navigator.mozGetUserMedia) {
		if(navigator.mozGetUserMedia) { //火狐调用
			getUserMedia({
				video: {
					width: 600,
					height: 480
				}
			}, success, error);
		} else if(navigator.webkitGetUserMedia) { //chrome46调用
			getUserMedia({
				"video": true
			}, success, error);
		}
	} else {
		$("#mark").hide();
		console.log('不支持访问用户媒体');
	}

	//确认已打开摄像头，并且图像符合要求				
	$("#confirm").on("click", function() {
		if(open == true) {
			$("#mark").hide();
			f(startTime, endTime, Number,pictures);
		} else {
			alert("请允许摄像头开启，刷新页面再次发起请求，否则不能开始考试");
		}
	})
}

//拍照
var times = 1;
function pictures() {
	var video = document.getElementById('video');
	var canvas = document.getElementById('canvas');
	var context = canvas.getContext('2d');
	context.drawImage(video, 0, 0, 600, 480);
	//console.log(canvas.toDataURL('jpeg'));
	
	var kuId = $("#kuId").val()
	$.ajax({
		url:baseUrl + '/mta/F030/submitBaseimg.html',
		data:{
			baseimg:canvas.toDataURL('jpeg'),
			kuId : kuId,
			times : times
		},
		type: 'post',
		dataType: 'json',
		success:function(data){
		
		if(data.count > 0){
			times++;

				//init();
				//saveTimer=setTimeout('init()',3000);
			}
		}
	});
	//mediaStream && mediaStream.stop()
}

//指定时间内调用指定次数
function f(min, max, n, callback) {

	var value, arr = [];
	for(var i = 0; i < n; i++) {
		value = Math.floor(Math.random() * (max - min + 1) + min);
		if(arr.indexOf(value) < 0) {
			arr.push(value);
		} else {
			i--;
		}
	}
	for(var j = 0; j < n; j++) {
		setTimeout(function() {
			callback()
		}, arr[j] * 1000)
	}
}

//ie调用
function videosIE(startTime, endTime, Number) {
	//拍照
	$(".play").click(function() {
		//console.log(webcam)
		webcam.capture(2); //拍照，参数5是倒计时
	});
	
	//模拟点击
	
	function tab(){
		$('.play').trigger("click")
	}
	var pos = 0,
		ctx = null,
		saveCB, image = [];
	var canvas = document.getElementById("canvas");
	ctx = canvas.getContext("2d");
	image = ctx.getImageData(0, 0, w, h);
	//console.log($("#webcam"))
	$("#webcam").webcam({
		width: w,
		height: h,
		mode: "callback", //stream,save，回调模式,流模式和保存模式
		swffile: "jscam_canvas_only.swf",
		onTick: function(remain) {
			if(0 == remain) {
				$("#status").text("拍照成功!");
			} else {
				$("#status").text("倒计时" + remain + "秒钟...");
			}
		},
		onSave: function(data) { //保存图像
			var col = data.split(";");
			var img = image;
			for(var i = 0; i < w; i++) {
				var tmp = parseInt(col[i]);
				img.data[pos + 0] = (tmp >> 16) & 0xff;
				img.data[pos + 1] = (tmp >> 8) & 0xff;
				img.data[pos + 2] = tmp & 0xff;
				img.data[pos + 3] = 0xff;
				pos += 4;
			}
			if(pos >= 4 * w * h) {
				ctx.putImageData(img, 0, 0); //转换图像数据，渲染canvas
				pos = 0;
				//Imagedata = canvas.toDataURL().substring(22); //上传给后台的图片数据
				Imagedata = canvas.toDataURL('jpeg'); //上传给后台的图片数据
				//console.log(Imagedata)
			}
		},
		onCapture: function() { //捕获图像
			webcam.save();
		},
		debug: function(type, string) { //控制台信息
			console.log(type + ": " + string);
			if(string == "Camera started") {
				f(0, 10, 5, tab);
			}
		},
		onLoad: function() { //flash 加载完毕执行
			console.log('加载完毕！')
			var cams = webcam.getCameraList();
			for(var i in cams) {
				$("body").append("<p>" + cams[i] + "</p>");
			}
		}
	});
}

//判断浏览器版本
function getBroswer() {
	var sys = {};
	var ua = navigator.userAgent.toLowerCase();
	var s;
	(s = ua.match(/edge\/([\d.]+)/)) ? sys.edge = s[1]:
		(s = ua.match(/rv:([\d.]+)\) like gecko/)) ? sys.ie = s[1] :
		(s = ua.match(/msie ([\d.]+)/)) ? sys.ie = s[1] :
		(s = ua.match(/firefox\/([\d.]+)/)) ? sys.firefox = s[1] :
		(s = ua.match(/chrome\/([\d.]+)/)) ? sys.chrome = s[1] :
		(s = ua.match(/opera.([\d.]+)/)) ? sys.opera = s[1] :
		(s = ua.match(/version\/([\d.]+).*safari/)) ? sys.safari = s[1] : 0;

	if(sys.edge) return {
		broswer: "Edge",
		version: sys.edge
	};
	if(sys.ie) return {
		broswer: "IE",
		version: sys.ie
	};
	if(sys.firefox) return {
		broswer: "Firefox",
		version: sys.firefox
	};
	if(sys.chrome) return {
		broswer: "Chrome",
		version: sys.chrome
	};
	if(sys.opera) return {
		broswer: "Opera",
		version: sys.opera
	};
	if(sys.safari) return {
		broswer: "Safari",
		version: sys.safari
	};

	return {
		broswer: "",
		version: "0"
	};
}
